/** @file   sensorcontroller.h
 * @brief   Declaration of SensorController - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SENSORCONTROLLER_H
#define H_WWW_SENSORCONTROLLER_H

#include "basecontroller.h"

namespace WeWantWar {

/** @class  SensorController
 * @brief   Represents a controller that can control mines.
 * @author  Tomi Lamminsaari
 *
 * This class represents some kind of radar controller. It has rotating
 * sensor that can react to GameObjects. So far this functionality has not
 * been implemented.
 *
 * Current implementation just checks the distance between the object we're
 * controlling and Player. If this distance is less than @c m_senseRange
 * we set the shoot-flag on.
 */
class SensorController : public BaseController
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================



  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     pOwner            Pointer to gameobject we're supposed to
   *                              control.
   */
	SensorController( GameObject* pOwner );


	/** Destructor
   */
	virtual ~SensorController();

private:

	/** Copy constructor.
   * @param     rO                Reference to another SensorController
   */
  SensorController( const SensorController& rO );

	/** Assignment operator
   * @param     rO                Reference to another SensorController
   * @return    Reference to us.
   */
  SensorController& operator = ( const SensorController& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this controller.
   */
  virtual void update();


  ///
  /// Getter methods
  /// ==============



  ///
  /// Members
  /// =======

  /** Direction where we scan at the moment. */
  int   m_scanDir;
  
  /** View angle we are capable of scanning once. 256 = every direction.*/
  int   m_viewAngle;
  
  /** How much the scanning direction rotates during each update. */
  int   m_scannerRotation;
  
  /** Maximum distance where we can sense the objects. */
  float m_senseRange;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: sensorcontroller.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:13+02  lamminsa
 * Initial revision
 *
 */
